"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
var capabilities_1 = require("./core/capabilities");
exports.hasProxy = capabilities_1.hasProxy;
exports.getValidCredentials = capabilities_1.getValidCredentials;
exports.inBrowser = capabilities_1.inBrowser;
exports.inElectron = capabilities_1.inElectron;
exports.isHeadless = capabilities_1.isHeadless;
exports.assertLocalAccess = capabilities_1.assertLocalAccess;
exports.assertHasProxy = capabilities_1.assertHasProxy;
exports.setHasAuth = capabilities_1.setHasAuth;
exports.getAuthValue = capabilities_1.getAuthValue;
var command_1 = require("./models/command");
exports.ExecType = command_1.ExecType;
var utility_1 = require("./core/utility");
exports.unparse = utility_1.optionsToString;
var entity_1 = require("./models/entity");
exports.isResourceByReference = entity_1.isMetadataBearingByReference;
var command_2 = require("./models/command");
exports.isCommandHandlerWithEvents = command_2.isCommandHandlerWithEvents;
var execOptions_1 = require("./models/execOptions");
exports.withLanguage = execOptions_1.withLanguage;
var editors_1 = require("./webapp/views/registrar/editors");
exports.registerEditor = editors_1.registerEditor;
var usage_error_1 = require("./core/usage-error");
exports.isUsageError = usage_error_1.isUsageError;
exports.UsageError = usage_error_1.UsageError;
var events_1 = require("./core/events");
exports.eventBus = events_1.default;
var i18n_1 = require("./util/i18n");
exports.i18nFromMap = i18n_1.fromMap;
exports.i18n = i18n_1.default;
var inject_1 = require("./webapp/util/inject");
exports.injectCSS = inject_1.injectCSS;
exports.injectScript = inject_1.injectScript;
exports.loadHTML = inject_1.loadHTML;
function History(tab) {
    return __awaiter(this, void 0, void 0, function* () {
        const model = (yield Promise.resolve().then(() => require('./models/history'))).default;
        return model;
    });
}
exports.History = History;
var time_1 = require("./webapp/util/time");
exports.prettyPrintTime = time_1.prettyPrintTime;
var strip_ansi_1 = require("./webapp/util/strip-ansi");
exports.stripAnsi = strip_ansi_1.default;
var pretty_print_1 = require("./webapp/util/pretty-print");
exports.prettyPrintAnsi = pretty_print_1.default;
function AsciiFormatters() {
    return __awaiter(this, void 0, void 0, function* () {
        const [{ formatUsage }, { preprocessTable, formatTable }] = yield Promise.all([
            Promise.resolve().then(() => require('./webapp/util/ascii-to-usage')),
            Promise.resolve().then(() => require('./webapp/util/ascii-to-table'))
        ]);
        return { formatUsage, preprocessTable, formatTable };
    });
}
exports.AsciiFormatters = AsciiFormatters;
var modes_1 = require("./webapp/views/registrar/modes");
exports.registerModeWhen = modes_1.registerModeWhen;
exports.registerMode = modes_1.registerSidecarMode;
var badges_1 = require("./webapp/views/registrar/badges");
exports.registerBadge = badges_1.registerSidecarBadge;
var split_1 = require("./repl/split");
exports.split = split_1.split;
exports._split = split_1._split;
var types_1 = require("./repl/types");
exports.DirectReplEval = types_1.DirectReplEval;
var encode_1 = require("./repl/encode");
exports.encodeComponent = encode_1.default;
var exec_1 = require("./repl/exec");
exports.getReplImpl = exec_1.getImpl;
exports.internalBeCarefulExec = exec_1.exec;
exports.internalBeCarefulPExec = exec_1.pexec;
exports.setEvaluatorImpl = exec_1.setEvaluatorImpl;
var sidecar_visibility_1 = require("./webapp/views/sidecar-visibility");
exports.isSidecarVisible = sidecar_visibility_1.isVisible;
exports.isSidecarFullscreen = sidecar_visibility_1.isFullscreen;
exports.hideSidecar = sidecar_visibility_1.hide;
exports.showSidecar = sidecar_visibility_1.show;
exports.toggleMaximization = sidecar_visibility_1.toggleMaximization;
exports.clearSelection = sidecar_visibility_1.clearSelection;
exports.currentSelection = sidecar_visibility_1.currentSelection;
var sidecar_state_1 = require("./webapp/views/sidecar-state");
exports.SidecarState = sidecar_state_1.SidecarState;
exports.getSidecarState = sidecar_state_1.getSidecarState;
var sidecar_visibility_2 = require("./webapp/views/sidecar-visibility");
exports.closeAllViews = sidecar_visibility_2.clearSelection;
var sidecar_selector_1 = require("./webapp/views/sidecar-selector");
exports.sidecarSelector = sidecar_selector_1.default;
var tab_1 = require("./webapp/tab");
exports.getTabFromTarget = tab_1.getTabFromTarget;
exports.getCurrentTab = tab_1.getCurrentTab;
exports.getTabId = tab_1.getTabId;
exports.sameTab = tab_1.sameTab;
var tab_state_1 = require("./models/tab-state");
exports.TabState = tab_state_1.default;
var find_1 = require("./webapp/themes/find");
exports.findThemeByName = find_1.findByName;
var default_1 = require("./webapp/themes/default");
exports.getDefaultTheme = default_1.getDefault;
var persistence_1 = require("./webapp/themes/persistence");
exports.switchToTheme = persistence_1.switchTo;
exports.getPersistedThemeChoice = persistence_1.getPersistedThemeChoice;
exports.resetToDefaultTheme = persistence_1.resetToDefault;
var prompt_1 = require("./webapp/prompt");
exports.getPrompt = prompt_1.getPrompt;
exports.getCurrentPrompt = prompt_1.getCurrentPrompt;
exports.getCurrentPromptLeft = prompt_1.getCurrentPromptLeft;
exports.getBlockOfPrompt = prompt_1.getBlockOfPrompt;
exports.setUsingCustomPrompt = prompt_1.setUsingCustomPrompt;
exports.unsetUsingCustomPrompt = prompt_1.unsetUsingCustomPrompt;
var block_1 = require("./webapp/block");
exports.getCurrentBlock = block_1.getCurrentBlock;
exports.getCurrentProcessingBlock = block_1.getCurrentProcessingBlock;
exports.resetCount = block_1.resetCount;
exports.setCustomCaret = block_1.setCustomCaret;
var status_1 = require("./webapp/status");
exports.setStatus = status_1.setStatus;
var listen_1 = require("./webapp/listen");
exports.internalBeCarefulListen = listen_1.listen;
var queueing_1 = require("./webapp/queueing");
exports.disableInputQueueing = queueing_1.disableInputQueueing;
exports.pasteQueuedInput = queueing_1.pasteQueuedInput;
var text_selection_1 = require("./webapp/text-selection");
exports.clearPendingTextSelection = text_selection_1.clearPendingTextSelection;
exports.setPendingTextSelection = text_selection_1.setPendingTextSelection;
exports.clearTextSelection = text_selection_1.clearTextSelection;
var popup_core_1 = require("./webapp/popup-core");
exports.isPopup = popup_core_1.isPopup;
var dom_1 = require("./webapp/util/dom");
exports.empty = dom_1.removeAllDomChildren;
var presentation_1 = require("./webapp/views/presentation");
exports.Presentation = presentation_1.default;
var toolbar_text_1 = require("./webapp/views/toolbar-text");
exports.ToolbarText = toolbar_text_1.ToolbarTextImpl;
var prompt_2 = require("./webapp/prompt");
exports.partialInput = prompt_2.partial;
exports.isUsingCustomPrompt = prompt_2.isUsingCustomPrompt;
var scroll_1 = require("./webapp/scroll");
exports.scrollIntoView = scroll_1.scrollIntoView;
var cancel_1 = require("./webapp/cancel");
exports.doCancel = cancel_1.default;
var element_mimic_1 = require("./util/element-mimic");
exports.ElementMimic = element_mimic_1.default;
var keys_1 = require("./webapp/keys");
exports.KeyCodes = keys_1.keys;
exports.isCursorMovement = keys_1.isCursorMovement;
var top_tabs_1 = require("./webapp/views/top-tabs");
exports.topTabButtonExists = top_tabs_1.buttonExists;
exports.topTabAddIcon = top_tabs_1.addIcon;
exports.topTabRemoveIcon = top_tabs_1.removeIcon;
var prompt_for_input_1 = require("./webapp/prompt-for-input");
exports.prompt = prompt_for_input_1.prompt;
var plugins_1 = require("./api/plugins");
exports.commandsOfferedByPlugin = plugins_1.commandsOffered;
exports.pluginUserHome = plugins_1.userHome;
var settings_1 = require("./core/settings");
exports.inBottomInputMode = settings_1.inBottomInputMode;
exports.userDataDir = settings_1.userDataDir;
exports.uiThemes = settings_1.uiThemes;
var store_1 = require("./models/store");
exports.Store = store_1.default;
var symbol_table_1 = require("./core/symbol-table");
exports.SymbolTable = symbol_table_1.default;
var table_1 = require("./webapp/models/table");
exports.TableStyle = table_1.TableStyle;
exports.Table = table_1.Table;
exports.Row = table_1.Row;
exports.Cell = table_1.Cell;
exports.isTable = table_1.isTable;
var find_file_1 = require("./core/find-file");
exports.findFileWithViewer = find_file_1.findFileWithViewer;
exports.findFile = find_file_1.findFile;
exports.isSpecialDirectory = find_file_1.isSpecialDirectory;
exports.augmentModuleLoadPath = find_file_1.addPath;
var home_1 = require("./util/home");
exports.expandHomeDir = home_1.expandHomeDir;
var utility_2 = require("./core/utility");
exports.flatten = utility_2.flatten;
var async_1 = require("./util/async");
exports.promiseEach = async_1.promiseEach;
var electron_events_1 = require("./webapp/electron-events");
exports.tellMain = electron_events_1.tellMain;
var main_1 = require("./main/main");
exports.main = main_1.main;
var boot_1 = require("./webapp/bootstrap/boot");
exports.boot = boot_1.default;
//# sourceMappingURL=index.js.map