"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const name_json_1 = require("@kui-shell/client/config.d/name.json");
const electron_1 = require("electron");
const isDev = false;
const tellRendererToExecute = (command, exec = 'qexec') => __awaiter(void 0, void 0, void 0, function* () {
    const { webContents } = yield Promise.resolve().then(() => require('electron'));
    const focusedWindow = webContents.getFocusedWebContents() || webContents.getAllWebContents()[0];
    const devTools = webContents
        .getAllWebContents()
        .map(_ => _.devToolsWebContents)
        .filter(x => x);
    const isFocusedWindowDevTools = devTools.find(_ => _.id === focusedWindow.id);
    if (isFocusedWindowDevTools) {
        const owningWindow = webContents.getAllWebContents().find(_ => {
            return _.devToolsWebContents && _.devToolsWebContents.id === focusedWindow.id;
        });
        if (owningWindow) {
            owningWindow.closeDevTools();
        }
    }
    else {
        focusedWindow.send(`/repl/${exec}`, { command });
    }
});
const newTab = () => tellRendererToExecute('tab new');
const closeTab = () => tellRendererToExecute('tab close');
exports.install = (createWindow) => {
    if (!isDev) {
        const fileMenuItems = [
            {
                label: 'New Window',
                click: () => createWindow(),
                accelerator: 'CommandOrControl+N'
            },
            {
                label: 'New Tab',
                click: () => newTab(),
                accelerator: 'CommandOrControl+T'
            },
            { type: 'separator' },
            {
                label: 'Close Tab',
                click: closeTab,
                accelerator: 'CommandOrControl+W'
            },
            { role: 'close' }
        ];
        if (process.platform !== 'darwin') {
            fileMenuItems.push({ type: 'separator' });
            fileMenuItems.push({ role: 'quit' });
        }
        const themeMenuItem = {
            label: 'Choose a Theme',
            click: () => {
                try {
                    tellRendererToExecute('themes', 'pexec');
                }
                catch (err) {
                    console.log(err);
                }
            }
        };
        const helpMenuItems = [
            {
                label: `Getting Started with ${name_json_1.productName}`,
                click: () => {
                    try {
                        tellRendererToExecute('about --mode gettingStarted');
                    }
                    catch (err) {
                        console.log(err);
                    }
                }
            },
            { type: 'separator' },
            {
                label: 'Report Issue...',
                click() {
                    require('electron').shell.openExternal('https://github.com/IBM/kui/issues/new');
                }
            }
        ];
        const menuTemplate = [
            {
                label: 'File',
                submenu: fileMenuItems
            },
            {
                label: 'Edit',
                submenu: [
                    { role: 'undo' },
                    { role: 'redo' },
                    { type: 'separator' },
                    { role: 'cut' },
                    { role: 'copy' },
                    { role: 'paste' },
                    { role: 'pasteAndMatchStyle' },
                    { role: 'delete' },
                    { role: 'selectAll' }
                ]
            },
            {
                label: 'View',
                submenu: [
                    themeMenuItem,
                    { type: 'separator' },
                    {
                        accelerator: process.platform === 'darwin' ? 'Meta+R' : 'Shift+CmdOrCtrl+R',
                        role: 'reload'
                    },
                    { role: 'toggleDevTools' },
                    { type: 'separator' },
                    { role: 'resetZoom' },
                    { role: 'zoomIn' },
                    { role: 'zoomOut' },
                    { type: 'separator' },
                    { role: 'togglefullscreen' }
                ]
            },
            {
                role: 'window',
                submenu: [{ role: 'minimize' }, { role: 'close' }]
            },
            {
                role: 'help',
                submenu: helpMenuItems
            }
        ];
        const about = {
            label: `About ${name_json_1.productName}`,
            click: () => {
                try {
                    tellRendererToExecute('about', 'pexec');
                }
                catch (err) {
                    console.log(err);
                }
            }
        };
        const separator = { type: 'separator' };
        const submenu = [
            about,
            separator,
            { role: 'services', submenu: [] },
            separator,
            { role: 'hide' },
            { role: 'hideOthers' },
            { role: 'unhide' },
            separator,
            { role: 'quit' }
        ];
        if (process.platform === 'darwin') {
            menuTemplate.unshift({
                label: name_json_1.productName,
                submenu
            });
        }
        else {
            helpMenuItems.push({ type: 'separator' });
            helpMenuItems.push(about);
        }
        const menu = electron_1.Menu.buildFromTemplate(menuTemplate);
        electron_1.Menu.setApplicationMenu(menu);
    }
};
//# sourceMappingURL=menu.js.map