import { UsageRow } from '../core/usage-error';
export interface HideError extends Error {
    hide?: boolean;
}
export declare function isHideError(err: Error): err is HideError;
export interface CodedError<Code = number> extends HideError {
    code?: Code;
    statusCode?: number;
    partialMatches?: UsageRow[];
    body?: string | Record<string, any>;
}
export declare function isCodedError<Code = number>(err: Error): err is CodedError<Code>;
