"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const plugins_1 = require("./plugins");
function commandsOffered(plugin) {
    return __awaiter(this, void 0, void 0, function* () {
        const { commandToPlugin, flat, usage, docs } = plugins_1.prescanModel();
        const commands = [];
        const pluginIsInstalled = !!flat.find(({ route }) => route === plugin);
        if (!pluginIsInstalled) {
            const err = new Error(`Plugin ${plugin} is not installed`);
            err.code = 404;
            throw err;
        }
        for (const command in commandToPlugin) {
            const hostingPlugin = commandToPlugin[command];
            if (plugin && hostingPlugin === plugin) {
                commands.push(command);
            }
        }
        commands.sort((a, b) => -a.localeCompare(b));
        function find(command, A = command.split('/'), idx = 2, prefix = `/${A[1]}`, subtree = usage[prefix]) {
            if (!subtree) {
                return;
            }
            if (A.length - idx === 0) {
                return subtree.usage;
            }
            else if (!subtree.children) {
            }
            else {
                const prefixPlus = `${prefix}/${A[idx]}`;
                return find(command, A, idx + 1, prefixPlus, subtree.children[prefixPlus]);
            }
        }
        return {
            header: {
                name: 'command',
                attributes: [{ value: 'About' }]
            },
            body: commands
                .map(command => ({ command, usage: find(command), name: command.replace(/^\//, '').replace(/\//g, ' ') }))
                .filter(_ => !_.usage || (!_.usage.synonymFor && !_.usage.children))
                .map(({ command, name }) => ({
                type: 'command',
                name: process.env.KUI_BIN_PREFIX_FOR_COMMANDS ? `${process.env.KUI_BIN_PREFIX_FOR_COMMANDS} ${name}` : name,
                attributes: [{ key: 'about', value: docs[command] }],
                onclick: name
            }))
        };
    });
}
exports.default = commandsOffered;
//# sourceMappingURL=commands.js.map