import { ThemeSet } from '../webapp/themes/Theme';
import { UsageModel } from '../core/usage-error';
import { Disambiguator, CapabilityRequirements, CatchAllHandler, KResponse, ParsedOptions } from '../models/command';
export interface PrescanNode extends CapabilityRequirements {
    route: string;
    usage?: UsageModel;
    docs?: string;
    synonyms?: string[];
    synonymFor?: string;
    children?: Record<string, PrescanNode>;
}
export declare type PrescanUsage = Record<string, PrescanNode>;
interface PrescanCommandDefinition {
    route: string;
    path: string;
}
export declare type PrescanCommandDefinitions = PrescanCommandDefinition[];
export interface PrescanDocs {
    [key: string]: string;
}
export interface PrescanModel {
    docs: PrescanDocs;
    preloads: PrescanCommandDefinitions;
    themeSets: ThemeSet[];
    commandToPlugin: {
        [key: string]: string;
    };
    topological: {
        [key: string]: string[];
    };
    flat: PrescanCommandDefinitions;
    overrides: {
        [key: string]: string;
    };
    usage: PrescanUsage;
    disambiguator?: Disambiguator;
    catchalls: CatchAllHandler<KResponse, ParsedOptions>[];
}
export declare function unify(modelA: PrescanModel, modelB: PrescanModel): PrescanModel;
export {};
