"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('core/util/mimic-dom');
debug('loading');
const store_1 = require("../main/store");
const element_mimic_1 = require("./element-mimic");
function default_1() {
    debug('mimicDom');
    global.window = {};
    try {
        global.localStorage = store_1.default();
        global.sessionStorage = store_1.default();
        debug('successfully initialized persistent localStorage');
    }
    catch (err) {
        debug('error initializing persistent localStorage', err);
        const _localStorage = {};
        const _sessionStorage = {};
        global.localStorage = {
            setItem: (k, v) => {
                _localStorage[k] = v;
                return v;
            },
            getItem: (k) => _localStorage[k] || null
        };
        global.sessionStorage = {
            setItem: (k, v) => {
                _sessionStorage[k] = v;
                return v;
            },
            getItem: (k) => _sessionStorage[k] || null
        };
    }
    finally {
        global.window.localStorage = localStorage;
        global.window.sessionStorage = sessionStorage;
    }
    window.addEventListener = () => true;
    const dom0 = () => {
        return new element_mimic_1.default();
    };
    global.document = {
        body: dom0(),
        createElement: (tag) => {
            const element = dom0();
            element.nodeType = tag;
            if (tag === 'table') {
                element.rows = [];
            }
            return element;
        },
        addEventListener: () => true,
        createTextNode: (text) => {
            const element = dom0();
            element.innerText = text;
            return element;
        },
        querySelector: (selector) => {
            return dom0();
        }
    };
    debug('mimicDom done');
}
exports.default = default_1;
//# sourceMappingURL=mimic-dom.js.map