"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("../../core/events");
function preinit() {
    return __awaiter(this, void 0, void 0, function* () {
        if (process.cwd() === '/') {
            try {
                process.chdir((yield Promise.resolve().then(() => require('../../util/home'))).default('~'));
                process.env.PWD = process.cwd();
            }
            catch (err) {
                console.error(err);
            }
        }
        let prefs = {};
        if (process.env.___IBM_FSH_FUZZ) {
            try {
                prefs = yield (yield Promise.resolve().then(() => require('../../core/fuzz-testing'))).default(process.env.___IBM_FSH_FUZZ);
            }
            catch (err) {
                console.error('Error parsing fuzz testing prefs', err);
            }
        }
        try {
            const { remote } = yield Promise.resolve().then(() => require('electron'));
            const window = remote && remote.getCurrentWindow();
            const subwindow = window.subwindow;
            if (subwindow && subwindow.fullscreen !== false) {
                const titleOverride = typeof subwindow === 'string' ? subwindow : subwindow.title;
                if (titleOverride && typeof titleOverride === 'string') {
                    document.title = titleOverride;
                }
                if (subwindow.viewName) {
                    document.body.setAttribute('data-view-name', subwindow.viewName);
                }
                document.body.classList.add('subwindow');
                if (subwindow.theme)
                    document.body.classList.add(`theme-${subwindow.theme}`);
                return subwindow;
            }
        }
        catch (err) {
        }
        return prefs;
    });
}
exports.preinit = preinit;
function init() {
    events_1.default.once('/init/done', () => __awaiter(this, void 0, void 0, function* () {
        const { remote } = yield Promise.resolve().then(() => require('electron'));
        const electronWindow = remote.getCurrentWindow();
        const prefs = electronWindow.subwindow;
        const argv = electronWindow['executeThisArgvPlease'];
        const maybeExecuteThis = argv && argv.length > 0 ? argv : undefined;
        const fullShell = maybeExecuteThis && maybeExecuteThis.length === 1 && maybeExecuteThis[0] === 'shell';
        if (maybeExecuteThis && !fullShell) {
            const command = typeof maybeExecuteThis === 'string' ? maybeExecuteThis : maybeExecuteThis.join(' ');
            if (prefs && prefs.partialExec) {
                const { partial } = yield Promise.resolve().then(() => require('../prompt'));
                partial(command);
            }
            else {
                const { pexec } = yield Promise.resolve().then(() => require('../../repl/exec'));
                const noEcho = prefs && prefs.noEcho;
                pexec(command, Object.assign(prefs || {}, {
                    causedByHeadless: true,
                    echo: !noEcho
                })).then(() => {
                });
            }
        }
    }));
}
exports.init = init;
//# sourceMappingURL=init-electron.js.map