"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.keys = {
    ENTER: 13,
    BACKSPACE: 127,
    ESCAPE: 27,
    TAB: 9,
    LEFT_ARROW: 37,
    A: 65,
    B: 66,
    C: 67,
    E: 69,
    F: 70,
    U: 85,
    UP: 38,
    P: 80,
    DOWN: 40,
    K: 75,
    L: 76,
    N: 78,
    R: 82,
    T: 'T'.charCodeAt(0),
    PAGEUP: 33,
    PAGEDOWN: 34,
    END: 35,
    HOME: 36
};
exports.Codes = exports.keys;
exports.isCursorMovement = (evt) => {
    const code = evt.keyCode;
    return evt.ctrlKey && (code === exports.keys.A || code === exports.keys.E || code === exports.keys.F || code === exports.keys.B);
};
//# sourceMappingURL=keys.js.map