"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/cli/listen');
debug('loading');
const style_json_1 = require("@kui-shell/client/config.d/style.json");
const capabilities_1 = require("../core/capabilities");
const keys_1 = require("./keys");
const cancel_1 = require("./cancel");
const paste_1 = require("./paste");
const tab_1 = require("./tab");
const popup_core_1 = require("./popup-core");
const prompt_1 = require("./prompt");
const settings_1 = require("../core/settings");
const sidecar_core_1 = require("./views/sidecar-core");
function isMSIEControl(ctrl) {
    return Object.prototype.hasOwnProperty.call(ctrl, 'createTextRange');
}
const setCaretPosition = (ctrl, pos) => {
    if (ctrl.setSelectionRange) {
        ctrl.focus();
        ctrl.setSelectionRange(pos, pos);
    }
    else if (isMSIEControl(ctrl)) {
        const range = ctrl.createTextRange();
        range.collapse(true);
        range.moveEnd('character', pos);
        range.moveStart('character', pos);
        range.select();
    }
};
const setCaretPositionToEnd = (input) => setCaretPosition(input, input.value.length);
const updateInputAndMoveCaretToEOL = (input, newValue) => {
    input.value = newValue;
    setTimeout(() => setCaretPositionToEnd(input), 0);
};
exports.unlisten = (prompt) => {
    if (settings_1.inBottomInputMode) {
        prompt = prompt_1.getBottomPrompt();
    }
    if (prompt) {
        prompt.readOnly = true;
        prompt.onkeypress = null;
        prompt.onkeydown = null;
        prompt.onpaste = null;
    }
    if (prompt && !prompt.classList.contains('sidecar-header-input')) {
        prompt.onkeypress = null;
        prompt.tabIndex = -1;
    }
};
exports.listen = (prompt) => {
    if (settings_1.inBottomInputMode) {
        const bottomPrompt = prompt_1.getBottomPrompt();
        bottomPrompt.readOnly = false;
        bottomPrompt.tabIndex = 1;
        if (prompt !== bottomPrompt) {
            prompt.readOnly = true;
        }
    }
    else {
        prompt.readOnly = false;
        prompt.placeholder = style_json_1.promptPlaceholder;
        prompt.tabIndex = 1;
    }
    const grandparent = prompt.parentNode.parentNode;
    grandparent.className = `${grandparent.getAttribute('data-base-class')} repl-active`;
    if (settings_1.inBottomInputMode) {
        prompt = prompt_1.getBottomPrompt();
        prompt.value = '';
    }
    if (!prompt.classList.contains('sidecar-header-input') &&
        !document.activeElement.classList.contains('grab-focus') &&
        document.activeElement !== prompt) {
        prompt.focus();
    }
    prompt.onkeypress = (event) => __awaiter(void 0, void 0, void 0, function* () {
        const char = event.keyCode;
        if (char === keys_1.keys.ENTER) {
            const { doEval } = yield Promise.resolve().then(() => require('../repl/exec'));
            doEval({ prompt });
        }
    });
    prompt.onkeydown = (event) => __awaiter(void 0, void 0, void 0, function* () {
        const char = event.keyCode;
        if (char === keys_1.keys.UP || (char === keys_1.keys.P && event.ctrlKey)) {
            if (!prompt_1.isUsingCustomPrompt(prompt)) {
                const historyModel = (yield Promise.resolve().then(() => require('../models/history'))).default;
                const newValue = (historyModel.previous() || { raw: '' }).raw;
                if (newValue) {
                    updateInputAndMoveCaretToEOL(prompt, newValue);
                }
            }
            else {
                event.preventDefault();
            }
        }
        else if (char === keys_1.keys.PAGEUP) {
            if (capabilities_1.inBrowser()) {
                debug('pageup');
                const { height } = document.body.getBoundingClientRect();
                document.querySelector('tab.visible .repl-inner').scrollBy(0, -height);
            }
        }
        else if (char === keys_1.keys.PAGEDOWN) {
            if (capabilities_1.inBrowser()) {
                debug('pagedown');
                const { height } = document.body.getBoundingClientRect();
                document.querySelector('tab.visible .repl-inner').scrollBy(0, +height);
            }
        }
        else if (char === keys_1.keys.C && event.ctrlKey) {
            cancel_1.default();
        }
        else if (char === keys_1.keys.U && event.ctrlKey) {
            prompt.value = '';
        }
        else if ((char === keys_1.keys.L && (event.ctrlKey || (capabilities_1.inElectron() && event.metaKey))) ||
            (process.platform === 'darwin' && char === keys_1.keys.K && event.metaKey)) {
            if (popup_core_1.isPopup()) {
            }
            else {
                const current = prompt_1.getCurrentPrompt().value;
                const { pexec } = yield Promise.resolve().then(() => require('../repl/exec'));
                const currentCursorPosition = prompt_1.getCurrentPrompt().selectionStart;
                yield pexec('clear');
                if (current) {
                    prompt_1.getCurrentPrompt().value = current;
                    debug('restoring cursor position', currentCursorPosition);
                    prompt_1.getCurrentPrompt().setSelectionRange(currentCursorPosition, currentCursorPosition);
                }
            }
        }
        else if (char === keys_1.keys.HOME) {
            const historyModel = (yield Promise.resolve().then(() => require('../models/history'))).default;
            const newValue = historyModel.first().raw;
            if (newValue) {
                updateInputAndMoveCaretToEOL(prompt, newValue);
            }
        }
        else if (char === keys_1.keys.END) {
            const historyModel = (yield Promise.resolve().then(() => require('../models/history'))).default;
            const newValue = (historyModel.last() || { raw: '' }).raw;
            updateInputAndMoveCaretToEOL(prompt, newValue);
        }
        else if (char === keys_1.keys.DOWN || (char === keys_1.keys.N && event.ctrlKey)) {
            if (!prompt_1.isUsingCustomPrompt(prompt)) {
                const historyModel = (yield Promise.resolve().then(() => require('../models/history'))).default;
                const newValue = (historyModel.next() || { raw: '' }).raw;
                updateInputAndMoveCaretToEOL(prompt, newValue);
            }
            else {
                event.preventDefault();
            }
        }
    });
    prompt.onpaste = paste_1.paste;
};
exports.popupListen = (text = sidecar_core_1.getSidecar(tab_1.getCurrentTab()).querySelector('.sidecar-header-text'), previousCommand) => {
    if (previousCommand) {
        const nameContainer = sidecar_core_1.getSidecar(tab_1.getCurrentTab()).querySelector('.sidecar-header-input');
        nameContainer.value = previousCommand;
    }
    const input = text.querySelector('.sidecar-header-input');
    exports.listen(input);
};
//# sourceMappingURL=listen.js.map