"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/pip');
debug('loading');
const dom_1 = require("./util/dom");
const sidecar_1 = require("./views/sidecar");
const listen_1 = require("./listen");
const presentation_1 = require("./views/presentation");
const exec_1 = require("../repl/exec");
const bottom_stripe_1 = require("./bottom-stripe");
const capturable_1 = require("./models/capturable");
const remove = (elt, cls) => elt.classList.remove(cls);
const add = (elt, cls) => elt.classList.add(cls);
const _highlight = (op) => (highlightThis) => {
    if (highlightThis) {
        if (Array.isArray(highlightThis)) {
            highlightThis.forEach(_ => op(_, 'picture-in-picture-highlight'));
        }
        else {
            op(highlightThis, 'picture-in-picture-highlight');
        }
    }
};
const dehighlight = _highlight(remove);
const highlight = _highlight(add);
const restore = (tab, pippedContainer, previousPresentation, sidecarClass, capturedHeaders, highlightThis, escapeHandler, options) => () => {
    debug('restore');
    const sidecar = sidecar_1.getSidecar(tab);
    const parent = (options && options.parent) || sidecar.querySelector('.custom-content');
    if (pippedContainer !== true) {
        dom_1.removeAllDomChildren(parent);
    }
    if (previousPresentation) {
        debug('restoring presentation mode', previousPresentation, presentation_1.default[previousPresentation].toString());
        document.body.setAttribute('data-presentation', presentation_1.default[previousPresentation].toString());
    }
    if (escapeHandler) {
        document.onkeyup = escapeHandler;
    }
    sidecar.className = sidecarClass;
    capturedHeaders.forEach(({ selector, node, redraw, nextSibling }) => {
        const curHeader = document.querySelector(selector);
        const curHeaderParent = curHeader.parentNode;
        curHeaderParent.removeChild(curHeader);
        curHeaderParent.insertBefore(node, nextSibling);
        if (redraw) {
            redraw(node);
        }
    });
    if (pippedContainer !== true && pippedContainer !== false) {
        if (!pippedContainer.classList.contains('sidecar-content')) {
            if (pippedContainer.parentNode) {
                pippedContainer.parentNode.removeChild(pippedContainer);
            }
            parent.appendChild(pippedContainer);
        }
    }
    dehighlight(highlightThis);
};
const pip = (tab, container, previousPresentation, capturedHeaders, highlightThis, returnTo = 'previous view', options) => {
    try {
        if (container !== true && container !== false) {
            if (!container.classList.contains('sidecar-content')) {
                container.parentNode.removeChild(container);
            }
        }
    }
    catch (e) {
    }
    const sidecar = sidecar_1.getSidecar(tab);
    const sidecarClass = sidecar.className;
    const escapeHandler = undefined;
    const backContainer = bottom_stripe_1.css.backContainer(tab);
    const backButton = bottom_stripe_1.css.backButton(tab);
    const restoreFn = restore(tab, container, previousPresentation, sidecarClass, capturedHeaders, highlightThis, escapeHandler, options);
    debug('returnTo', returnTo);
    backButton.setAttribute('data-balloon', `Return to ${returnTo}`);
    backContainer.classList.add('has-back-button');
    backButton.addEventListener('click', () => __awaiter(void 0, void 0, void 0, function* () {
        yield (tab.state.drilldownInProgress || Promise.resolve());
        restoreFn();
        backContainer.classList.remove('has-back-button');
    }), { once: true });
    return restoreFn;
};
const capture = (tab, selector, redraw) => {
    const node = tab.querySelector(selector);
    const clone = node.cloneNode(true);
    const parent = node.parentNode;
    const nextSibling = node.nextSibling;
    node.remove();
    parent.insertBefore(clone, nextSibling);
    return {
        selector,
        node,
        redraw,
        nextSibling
    };
};
exports.drilldown = (tab, command, highlightThis, ccontainer, returnTo, options) => (event) => __awaiter(void 0, void 0, void 0, function* () {
    if (event)
        event.stopPropagation();
    const container = typeof ccontainer === 'string' ? document.querySelector(ccontainer) : ccontainer || sidecar_1.getActiveView(tab);
    debug('drilldown', command, container, returnTo);
    const alreadyPipped = document.querySelector('body > .picture-in-picture');
    const presentationString = document.body.getAttribute('data-presentation');
    const presentation = presentationString && presentation_1.default[presentationString];
    const capturedHeader = capture(tab, '.sidecar-header-text', listen_1.popupListen);
    const capturedHeader2 = capture(tab, '.header-right-bits .custom-header-content');
    const capturedHeader3 = capture(tab, '.header-right-bits .action-content');
    const capturedHeader4 = capture(tab, '.sidecar-header-icon');
    const capturedHeader5 = capture(tab, '.sidecar-header-secondary-content');
    const modeContainer = bottom_stripe_1.css.modeContainer(tab);
    const modeButtons = capturable_1.isCapturable(modeContainer) && modeContainer.capture;
    const capturedFooter = capture(tab, bottom_stripe_1.rawCSS.buttons, modeButtons && modeButtons());
    const capturedHeaders = [
        capturedHeader,
        capturedHeader2,
        capturedHeader3,
        capturedHeader4,
        capturedHeader5,
        capturedFooter
    ];
    const restoreFn = container && !alreadyPipped
        ? pip(tab, container, presentation, capturedHeaders, highlightThis, returnTo, options)
        : () => true;
    highlight(highlightThis);
    debug('executing command', command);
    tab.state.drilldownInProgress = new Promise((resolve) => __awaiter(void 0, void 0, void 0, function* () {
        const done = () => {
            tab.state.drilldownInProgress = undefined;
            resolve();
        };
        if (typeof command === 'string') {
            debug('drilling down with string command');
            const execOptions = Object.assign({}, {
                isDrilldown: true,
                preserveBackButton: true,
                rethrowErrors: true,
                reportErrors: true
            }, (options && options.execOptions) || {});
            if (!options || options.exec === 'pexec') {
                return exec_1.pexec(command, execOptions)
                    .then(done)
                    .catch(restoreFn);
            }
            else {
                return exec_1.qexec(command, undefined, undefined, execOptions)
                    .then(done)
                    .catch(restoreFn);
            }
        }
        else if (typeof command === 'function') {
            return command()
                .then(done)
                .catch(restoreFn);
        }
        else {
            console.error('no viewer for content');
            done();
        }
    }));
    yield tab.state.drilldownInProgress;
});
exports.default = exports.drilldown;
//# sourceMappingURL=picture-in-picture.js.map