"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const style_json_1 = require("@kui-shell/client/config.d/style.json");
const find_1 = require("./find");
const settings_1 = require("../../core/settings");
const debug = debug_1.default('core/webapp/themes/default');
function getDefault(isDarkMode = false) {
    return __awaiter(this, void 0, void 0, function* () {
        let defaultTheme = style_json_1.defaultTheme;
        if (isDarkMode) {
            const darkThemeModel = yield find_1.default('Dark');
            if (darkThemeModel) {
                defaultTheme = darkThemeModel.theme.name;
            }
        }
        if (!defaultTheme) {
            console.error('theme bug: the theme does not set a default theme');
            defaultTheme = yield settings_1.uiThemes()
                .then(themeSets => themeSets[0].themes[0].name)
                .catch(() => {
                throw new Error('SEVERE theme bug: no theme found');
            });
            if (!defaultTheme) {
                throw new Error('SEVERE theme bug: no theme found');
            }
        }
        debug('using default theme %s', defaultTheme);
        return defaultTheme;
    });
}
exports.getDefault = getDefault;
exports.default = getDefault;
//# sourceMappingURL=default.js.map