"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
function makeConverter() {
    return __awaiter(this, void 0, void 0, function* () {
        const Convert = require('ansi-to-html');
        return new Convert({
            newline: true,
            escapeXML: true,
            bg: 'var(--color-ui-01)',
            fg: 'var(--color-text-01)',
            colors: {
                0: 'var(--color-black)',
                1: 'var(--color-red)',
                2: 'var(--color-green)',
                3: 'var(--color-yellow-text)',
                4: 'var(--color-blue)',
                5: 'var(--color-magenta)',
                6: 'var(--color-cyan)',
                7: 'var(--color-white)',
                8: 'var(--color-black)',
                9: 'var(--color-red)',
                10: 'var(--color-green)',
                11: 'var(--color-yellow)',
                12: 'var(--color-blue)',
                13: 'var(--color-magenta)',
                14: 'var(--color-cyan)',
                15: 'var(--color-white)'
            }
        });
    });
}
function trim(strings) {
    let idx = strings.length - 1;
    for (; idx >= 0; idx--) {
        if (strings[idx].length > 0) {
            break;
        }
    }
    if (idx > 0) {
        return strings.slice(0, idx + 1);
    }
    else {
        return strings;
    }
}
function formatAsPty(_strings, wrap = true) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!_strings || (_strings.length === 1 && _strings.every(_ => _.length === 0 || /^\s+$/.test(_)))) {
            return;
        }
        const convert = yield makeConverter();
        const { flatten } = yield Promise.resolve().then(() => require('../../core/utility'));
        const strings = trim(flatten(_strings.map(_ => _.split(/[\n]/))));
        const container = document.createElement('div');
        const formatLine = (_) => {
            const line = document.createElement('div');
            container.appendChild(line);
            if (wrap) {
                line.classList.add('pre-wrap');
            }
            line.innerHTML = convert.toHtml(_);
        };
        strings.forEach(formatLine);
        if (strings.length === 1) {
            const single = container.children[0];
            if (single.children.length === 0) {
                return;
            }
            else if (single.children.length === 1) {
                return single.children[0];
            }
            else {
                return single;
            }
        }
        return container;
    });
}
exports.default = formatAsPty;
//# sourceMappingURL=pretty-print.js.map