"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const badge_1 = require("../badge");
const debug = debug_1.default('webapp/views/registrar/badges');
const registrar = [];
function registerSidecarBadge(registration) {
    registrar.push(registration);
}
exports.registerSidecarBadge = registerSidecarBadge;
exports.default = registerSidecarBadge;
function apply(tab, entity, badgeOptions) {
    registrar
        .filter(({ when }) => {
        try {
            return when(entity.resource);
        }
        catch (err) {
            debug('warning: registered badge threw an exception during filter', err);
            return false;
        }
    })
        .forEach(({ badge }) => {
        if (typeof badge === 'function') {
            badge_1.addBadge(tab, badge(entity.resource, tab), badgeOptions);
        }
        else {
            badge_1.addBadge(tab, badge, badgeOptions);
        }
    });
}
exports.apply = apply;
//# sourceMappingURL=badges.js.map