"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const popup_core_1 = require("../popup-core");
const presentation_1 = require("./presentation");
const sidecar_visibility_1 = require("./sidecar-visibility");
exports.default = (tab, presentation) => {
    if (presentation || presentation === presentation_1.default.Default) {
        document.body.setAttribute('data-presentation', presentation_1.default[presentation].toString());
        if (!popup_core_1.isPopup() && presentation === presentation_1.default.Default && tab.getAttribute('maximization-cause') !== 'user') {
            sidecar_visibility_1.setMaximization(tab, sidecar_visibility_1.remove);
        }
    }
    else {
        document.body.removeAttribute('data-presentation');
    }
};
//# sourceMappingURL=sidecar-present.js.map