import { Sidecar, CustomSpec } from './sidecar-core';
import { Tab } from '../tab';
import { MetadataBearing } from '../../models/entity';
export declare const enableTabIndex: (sidecar: Sidecar, tabbable?: boolean) => void;
export declare const isVisible: (tab: Tab) => boolean;
export declare const setVisibleClass: (sidecar: Sidecar) => void;
export declare const currentSelection: (tab: Tab) => MetadataBearing<void> | CustomSpec<void>;
export declare const show: (tab: Tab, block?: HTMLElement, nextBlock?: HTMLElement) => Promise<boolean>;
export declare const hide: (tab: Tab, clearSelectionToo?: boolean) => boolean;
export declare const clearSelection: (tab: Tab) => boolean;
export declare const toggle: (tab: Tab) => boolean | Promise<boolean>;
declare type Op = (elt: Element, cls: string) => void;
export declare const remove: Op;
export declare const setMaximization: (tab: Tab, op?: Op, cause?: MaximizationCause) => void;
declare type MaximizationCause = 'default' | 'user';
export declare const toggleMaximization: (tab: Tab, cause?: MaximizationCause) => void;
export declare const isFullscreen: (tab: Tab) => boolean;
export {};
