"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Marked = require("marked");
const dom_1 = require("../util/dom");
class ToolbarTextImpl {
    constructor(type, text) {
        this.type = type;
        this.text = text;
    }
    attach(owner) {
        this._container = dom_1.element('.sidecar-bottom-stripe-toolbar .sidecar-toolbar-text', owner);
        return this;
    }
    refresh() {
        if (this._container) {
            const content = dom_1.element('.sidecar-toolbar-text-content', this._container);
            if (typeof this.text === 'string') {
                content.innerHTML = Marked(this.text);
            }
            else {
                content.appendChild(this.text);
            }
            this._container.setAttribute('data-type', this.type);
        }
    }
}
exports.ToolbarTextImpl = ToolbarTextImpl;
function isToolbarText(subtext) {
    const spec = subtext;
    return spec && spec.type !== undefined && spec.text !== undefined;
}
exports.isToolbarText = isToolbarText;
function isRefreshableToolbarText(ttext) {
    const refreshable = ttext;
    return refreshable.attach !== undefined && refreshable.refresh !== undefined;
}
exports.isRefreshableToolbarText = isRefreshableToolbarText;
//# sourceMappingURL=toolbar-text.js.map