import { Table, Row } from '../webapp/models/table';
import { CustomSpec } from '../webapp/views/sidecar';
import { ToolbarText } from '../webapp/views/toolbar-text';
import { UsageModel } from '../core/usage-error';
import { MultiModalResponse } from './mmr/types';
export interface MessageBearingEntity {
    message: string;
}
export declare function isMessageBearingEntity(entity: Entity): entity is MessageBearingEntity;
/**
 * The name part of a metadata bearing resource.
 *
 */
interface MetadataNamedResource {
    kind?: string;
    metadata?: {
        name: string;
        namespace?: string;
        generation?: string;
        creationTimestamp?: string;
    };
}
/**
 * A minimal subset of a kubernetes-like resource specification that
 * identifies a resource
 *
 */
export interface MetadataBearing<Content = void> extends MetadataNamedResource {
    apiVersion?: string;
    /** optional designation of resource version */
    version?: string;
    /** name hash, e.g. the hash part of auto-generated names, or an openwhisk activation id */
    prettyName?: string;
    nameHash?: string;
    /** family of onclick handlers */
    onclick?: {
        name?: string;
        nameHash?: string;
        namespace?: string;
    };
    content?: Content;
    contentType?: string;
    toolbarText?: ToolbarText;
}
export declare function isMetadataBearing(spec: MetadataBearing | Entity): spec is MetadataBearing;
export interface WithDisplayName extends MetadataBearing {
    spec: {
        displayName: string;
    };
}
export declare function hasDisplayName(resource: MetadataBearing): resource is WithDisplayName;
/**
 * Entity with a "resource" field that is MetadataBearing
 *
 */
export interface MetadataBearingByReference<Content = void> extends CustomSpec<Content> {
    resource: MetadataBearing<Content>;
}
export declare function isMetadataBearingByReference(spec: MetadataBearing | MetadataBearingByReference | Entity): spec is MetadataBearingByReference;
/**
 * A mostly scalar entity
 *
 */
export declare type SimpleEntity = boolean | string | number | HTMLElement | MessageBearingEntity | Error;
/**
 * The plugin returns a mix of types; e.g. `helm status` returns
 * [string, Table, string], where the status `Table` is sandwiched by
 * preface and trailing `string` messages
 *
 */
export declare type MixedResponsePart = string | Table | HTMLElement;
export declare type MixedResponse = MixedResponsePart[];
export declare function isMixedResponse(response: Entity): response is MixedResponse;
/**
 * We will do away with this at some point; but, for now, the
 * cli.prompt takes over the REPL temporarily.
 *
 */
export interface LowLevelLoop {
    mode: 'prompt';
}
export declare function isLowLevelLoop(entity: Entity): entity is LowLevelLoop;
/**
 * Transforms optional fields to required fields
 *
 */
declare type Complete<T> = {
    [P in keyof Required<T>]: Pick<T, P> extends Required<Pick<T, P>> ? T[P] : (T[P] | undefined);
};
/**
 * A `ResourceModification` command response allows a plugin to inform
 * the core that a CRUD action has been performed against a named
 * resource.
 *
 */
export declare type ResourceModification = Complete<MetadataNamedResource> & {
    /** for now, we only support deletion modifications */
    verb: 'delete';
};
export declare function isResourceModification(entity: Entity): entity is ResourceModification;
/**
 * This allows commands to pass through raw responses from their backend
 *
 */
export declare type RawContent = any;
export interface RawResponse<Content extends RawContent> {
    mode: 'raw';
    content: Content;
}
export declare function isRawResponse<Content extends RawContent>(entity: Entity<Content>): entity is RawResponse<Content>;
/**
 * A potentially more complex entity with a "spec"
 *
 */
export declare type Entity<Content = void, RowType extends Row = Row, Meta extends MetadataBearing<Content> = MetadataBearing<Content>> = SimpleEntity | Table<RowType> | ResourceModification | CustomSpec | MixedResponse | MultiModalResponse | LowLevelLoop | UsageModel | Meta | RawResponse<Content>;
export {};
