/*
 * Copyright 2017-2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
const debug = Debug('core/plugins');
debug('loading');
import preloader from './preloader';
import { makeResolver } from './resolver';
import { unify } from './prescan';
import { userDataDir } from '../core/userdata';
import { isHeadless } from '../core/capabilities';
import { setPluginResolver } from '../core/command-tree';
debug('modules loaded');
export const pluginRoot = '../../../../plugins';
/**
 * This is the registrar for plugins used at runtime (i.e. "live, not
 * scanning"). This is not related to the prescan computation.
 *
 */
export const registrar = {};
/**
 * When in "live, not scanning" mode, this state will store the result
 * of a previous plugin scan
 *
 */
let basePrescan; // without any user-installed plugins
let prescan; // the result of unify(basePrescan, userPrescan)
export function prescanModel() {
    if (!prescan) {
        return require('@kui-shell/prescan.json');
    }
    return prescan;
}
/**
 * For internal use only: set the prescan model
 *
 */
export function _useUpdatedUserPrescan(userPrescan) {
    debug('useUpdatedUserPrescan', userPrescan, basePrescan);
    prescan = unify(basePrescan, userPrescan);
    setPluginResolver(makeResolver(prescan, registrar));
}
export const preload = () => {
    preloader(prescan);
};
/**
 * @return the home directory for user-installed plugins. All
 * artifacts related to user-installed plugins will be stored within
 * this directory.
 *
 */
export function userInstalledHome() {
    return __awaiter(this, void 0, void 0, function* () {
        const { join } = yield import('path');
        const rootDir = userDataDir();
        return join(rootDir, 'plugins');
    });
}
/**
 * Load the prescan model, in preparation for loading the shell
 *
 * @return truthy value if we indeed did the initialization
 */
export const init = () => __awaiter(void 0, void 0, void 0, function* () {
    debug('init');
    if (prescan) {
        return false;
    }
    // pre-installed pluginds
    try {
        prescan = (yield import('@kui-shell/prescan.json'));
        basePrescan = prescan;
        debug('pre-installed prescan loaded');
    }
    catch (err) {
        console.error('prescanned does not exist or is not valid JSON', err);
    }
    if (isHeadless() && prescan) {
        try {
            const [{ existsSync }, { join }] = yield Promise.all([import('fs'), import('path')]);
            const userPath = join(yield userInstalledHome(), 'node_modules/@kui-shell/prescan.json');
            if (existsSync(userPath)) {
                const userInstalledPrescan = (yield import(userPath));
                // merge builtin plugins with user-installed plugins
                prescan = unify(prescan, userInstalledPrescan);
                // debug('prescan', prescan)
            }
            debug('user-installed prescan loaded', prescan);
        }
        catch (err) {
            console.error('error loading user-installed prescan', err);
        }
    }
    /* const { default: eventBus } = await import('../core/events')
    eventBus.on('/plugin/compile/request', async (pluginToBeRemoved?: string) => {
      const { compileUserInstalled } = await import('./assembler')
      compileUserInstalled(pluginToBeRemoved)
    }) */
    setPluginResolver(makeResolver(prescan, registrar));
    debug('init done');
    return true;
});
debug('done loading');
//# sourceMappingURL=plugins.js.map