import { Tab } from '../../tab';
import { CustomSpec } from '../sidecar-core';
import Presentation from '../presentation';
import { ExecOptions } from '../../../models/execOptions';
export interface EditorProvider {
    tryOpen: (tab: Tab, spec: CustomSpec, options: ExecOptions) => Promise<{
        content: Element;
        presentation: Presentation;
    }>;
}
/**
 * Register an editor
 *
 */
export declare function registerEditor(provider: EditorProvider): void;
export default registerEditor;
/**
 * Do we have an editor capability?
 *
 */
export declare function hasEditor(): boolean;
/**
 * Apply all registered modes that are relevant to the given resource
 * to the given modes model
 *
 */
export declare function tryOpenWithEditor(tab: Tab, spec: CustomSpec, options: ExecOptions): Promise<{
    content: Element;
    presentation: Presentation;
}>;
