import { Tab } from '../tab';
import { Badge } from './badge';
import { ToolbarText } from './toolbar-text';
import Formattable from './formattable';
import Presentation from './presentation';
import { SidecarMode } from '../bottom-stripe';
import { MetadataBearing } from '../../models/entity';
export declare type CustomContent = string | Record<string, any> | HTMLElement | Promise<HTMLElement>;
export interface CustomSpec<Content = void> extends MetadataBearing<CustomContent> {
    /** noZoom: set to true for custom content to control the zoom event handler */
    type: 'custom';
    noZoom?: boolean;
    isREPL?: boolean;
    presentation?: Presentation;
    renderAs?: string;
    subtext?: Formattable;
    toolbarText?: ToolbarText;
    content: CustomContent;
    badges?: Badge[];
    resource?: MetadataBearing<Content>;
    createdOnString?: string;
    prettyType?: string;
    prettyName?: string;
    displayOptions?: string[];
    controlHeaders?: boolean | string[];
    sidecarHeader?: boolean;
    modes?: SidecarMode[];
    uuid?: string;
}
/**
 * Return the sidecar model
 *
 */
export interface Sidecar extends HTMLElement {
    entity: MetadataBearing | CustomSpec;
    uuid?: string;
}
export declare const getSidecar: (tab: Tab) => Sidecar;
