import { Tab } from '../tab';
import { Block } from '../models/block';
import { ParsedOptions } from '../../models/command';
import { Table, Row } from '../models/table';
/** RowFormatOptions helps FormatOneRowResult render the `Row` */
export interface RowFormatOptions {
    excludePackageName?: boolean;
    useRepeatingEffect?: boolean;
    usePip?: boolean;
}
/**
 * Format one row in the table
 *
 */
export declare const formatOneRowResult: (tab: Tab, options: RowFormatOptions, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}) => (entity: Row) => HTMLElement;
/**
 * Format the table view
 *
 */
export declare const formatTable: (tab: Tab, response: Table<Row>, resultDom: HTMLElement, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}, options?: {
    block?: Block;
    usePip?: boolean;
}) => void;
