"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sidecar_support_1 = require("../util/sidecar-support");
exports.reallyLong = str => str.split(/[\n\r]/).length > 20;
exports.handleNonZeroExitCode = (command, exitCode, rawOut, rawErr, execOptions, parentNode) => {
    const stderr = rawErr.length === 0 ? rawOut : rawErr;
    if (execOptions && execOptions.nested && exitCode !== 127) {
        const error = new Error(stderr);
        error['code'] = exitCode;
        throw error;
    }
    else {
        const error = new Error(stderr);
        if ((!execOptions || !execOptions.raw) && exports.reallyLong(stderr)) {
            return sidecar_support_1.asSidecarEntity(command, parentNode || stderr);
        }
        else {
            error['html'] = parentNode;
        }
        if (execOptions.stderr)
            error['code'] = parentNode;
        else if (stderr.match(/File exists/i))
            error['code'] = 409;
        else if (exitCode !== 127 && stderr.match(/not found/i))
            error['code'] = 404;
        else
            error['code'] = exitCode;
        throw error;
    }
};
//# sourceMappingURL=exec.js.map