"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/bash-like/preload');
debug('loading');
const core_1 = require("@kui-shell/core");
const catchall_1 = require("./lib/cmds/catchall");
exports.registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
    if (core_1.inBrowser()) {
        yield Promise.resolve().then(() => require('./pty/session')).then(({ init }) => init());
    }
    else {
        try {
            const prefetchShellState = (yield Promise.resolve().then(() => require('./pty/prefetch'))).default;
            yield prefetchShellState();
            debug('done with state prefetch');
        }
        catch (err) {
            console.error('error in state prefetch', err);
        }
    }
});
exports.default = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    return catchall_1.preload(commandTree);
});
debug('finished loading');
//# sourceMappingURL=preload.js.map