"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const url = require("url");
const path = require("path");
const Marked = require("marked");
const renderLink = (fullpath) => (link) => {
    const { href } = link;
    const parsedUrl = url.parse(href);
    const isRemote = parsedUrl.protocol !== undefined && parsedUrl.protocol !== 'file:';
    if (!isRemote && parsedUrl.pathname) {
        const url = href.charAt(0) === '!'
            ? href
            : path.relative(process.cwd(), path.normalize(path.join(path.dirname(fullpath), parsedUrl.pathname)));
        link.href = parsedUrl.hash || '#';
        link.setAttribute('data-url', url);
    }
    if (!isRemote) {
        link.classList.add('repl-pexec-link');
    }
    else {
        link.target = '_blank';
    }
    link.classList.add('bx--link');
};
const wrap = (tab, htmlString, fullpath) => {
    const body = document.createElement('div');
    body.classList.add('padding-content');
    body.classList.add('overflow-auto');
    const wrapper = document.createElement('div');
    wrapper.innerHTML = htmlString;
    wrapper.classList.add('page-content');
    body.appendChild(wrapper);
    const links = wrapper.querySelectorAll('a');
    const rendLink = renderLink(fullpath);
    for (let idx = 0; idx < links.length; idx++) {
        const link = links[idx];
        rendLink(link);
    }
    const pexecs = wrapper.querySelectorAll('a.repl-pexec-link');
    for (let idx = 0; idx < pexecs.length; idx++) {
        const exec = pexecs[idx];
        const url = exec.getAttribute('data-url');
        if (url && url.charAt(0) === '!') {
            exec.onclick = () => tab.REPL.pexec(url
                .substring(1)
                .replace(/\\\//, '/')
                .replace(/\$\{cwd\}/g, path.dirname(fullpath)));
        }
        else {
            exec.onclick = () => tab.REPL.pexec(`open ${url}`);
        }
    }
    const titles = wrapper.querySelectorAll('h1');
    let title;
    if (titles.length === 1) {
        title = titles[0];
        title.parentNode.removeChild(title);
    }
    if (typeof hljs !== 'undefined') {
        const codes = wrapper.querySelectorAll('pre > code');
        for (let idx = 0; idx < codes.length; idx++) {
            codes[idx].classList.add('fancy-code');
            setTimeout(() => hljs.highlightBlock(codes[idx]), 0);
        }
    }
    const tables = wrapper.querySelectorAll('table');
    for (let idx = 0; idx < tables.length; idx++) {
        const table = tables[idx];
        table.classList.add('log-lines');
        const rows = table.querySelectorAll('tr');
        for (let idx = 0; idx < rows.length; idx++) {
            rows[idx].classList.add('log-line');
            {
                const cells = rows[idx].querySelectorAll('td');
                for (let jdx = 0; jdx < cells.length; jdx++) {
                    cells[jdx].classList.add('log-field');
                }
            }
            {
                const cells = rows[idx].querySelectorAll('th');
                for (let jdx = 0; jdx < cells.length; jdx++) {
                    cells[jdx].classList.add('log-field');
                    cells[jdx].classList.add('header-cell');
                }
            }
        }
    }
    return { title, body };
};
const markdownify = (tab, source, fullpath) => __awaiter(void 0, void 0, void 0, function* () {
    const renderer = new Marked.Renderer();
    const transformHref = (href) => {
        const parsedUrl = url.parse(href);
        const isRemote = !!parsedUrl.protocol;
        if (!isRemote && parsedUrl.pathname) {
            const newHref = href.charAt(0) === '!' ? href : path.join(path.dirname(fullpath), parsedUrl.pathname);
            return newHref;
        }
        else {
            return href;
        }
    };
    renderer.html = (html) => {
        const tmp = document.createElement('div');
        tmp.style.position = 'absolute';
        tmp.style.top = '-10000';
        tmp.style.left = '-10000';
        tmp.innerHTML = html;
        const images = tmp.querySelectorAll('img');
        for (let idx = 0; idx < images.length; idx++) {
            const image = images[idx];
            if (image.src) {
                image.setAttribute('src', transformHref(image.getAttribute('src')));
            }
        }
        return tmp.innerHTML;
    };
    renderer.image = (href, title, text) => {
        return `<img src='${transformHref(href)}'` + (title ? ' title="' + title + '"' : '') + ` alt="${text}"></img>`;
    };
    renderer.link = (href, title, text) => {
        const link = document.createElement('a');
        link.href = href;
        if (title)
            link.title = title;
        link.innerHTML = text;
        renderLink(fullpath);
        return link.outerHTML;
    };
    const marked = _ => Marked(_, { renderer });
    const htmlString = marked(source);
    return wrap(tab, htmlString, fullpath);
});
exports.default = (tab, suffix, source, fullpath) => {
    if (suffix === 'md') {
        return markdownify(tab, source, fullpath);
    }
};
//# sourceMappingURL=markdown.js.map