/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { unlink } from 'fs';
import { fileSync as tmpFile } from 'tmp';
import { promisify } from 'util';
import { Common, CLI, Keys, ReplExpect, Selectors } from '@kui-shell/test';
/** helpful selectors */
const rows = (N) => Selectors.xtermRows(N);
const lastRow = (N) => `${rows(N)} > div:last-child`;
describe(`xterm vi 1 ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const typeThisText = 'hello there';
    const file = tmpFile();
    Common.pit('use vi to create a new file', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`vim -i NONE ${file.name}`, this.app);
            // wait for vi to come up
            yield this.app.client.waitForExist(rows(res.count));
            // wait for vi to come up in alt buffer mode
            yield this.app.client.waitForExist(`tab.visible.xterm-alt-buffer-mode`);
            // enter insert mode, and wait for INSERT to appear at the bottom
            let iter = 0;
            yield this.app.client.keys('i');
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const txt = yield this.app.client.getText(lastRow(res.count));
                if (++iter > 5) {
                    console.error('xterm vi still waiting for Insert mode', txt);
                }
                return /INSERT/i.test(txt);
            }));
            // type our input
            yield this.app.client.keys(typeThisText);
            // exit from insert mode
            iter = 0;
            yield this.app.client.keys(Keys.ESCAPE);
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const txt = yield lastRow(res.count);
                if (++iter > 5) {
                    console.error('xterm vi still waiting to exit insert mode', txt);
                }
                return !/INSERT/i.test(txt);
            }));
            yield this.app.client.keys(':wq');
            yield this.app.client.keys(Keys.ENTER);
            yield ReplExpect.blank(res);
            yield CLI.command(`cat ${file.name}`, this.app).then(ReplExpect.okWithString('hello there'));
        }
        catch (err) {
            return Common.oops(this)(err);
        }
    }));
    Common.pit('should cat the file contents', () => CLI.command(`cat "${file.name}"`, this.app)
        .then(ReplExpect.okWithString('hello there'))
        .catch(Common.oops(this)));
    Common.pit('should remove the temp file', () => __awaiter(this, void 0, void 0, function* () {
        // DO NOT return a promise here; see https://github.com/mochajs/mocha/issues/3555
        yield promisify(unlink)(file.name);
    }));
});
describe(`xterm vi 2 ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    Common.pit('open vi :wq then :q, and expect no error', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`vim -i NONE`, this.app);
            // wait for vi to come up
            yield this.app.client.waitForExist(rows(res.count));
            // wait for vi to come up in alt buffer mode
            yield this.app.client.waitForExist(`tab.visible.xterm-alt-buffer-mode`);
            // :wq
            yield this.app.client.keys(':wq');
            yield this.app.client.keys(Keys.ENTER);
            // :q
            yield this.app.client.keys(':q');
            yield this.app.client.keys(Keys.ENTER);
            // expect a clean exit, i.e. no error output on the console
            yield ReplExpect.blank(res);
        }
        catch (err) {
            return Common.oops(this)(err);
        }
    }));
});
//# sourceMappingURL=vi.js.map