"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const usage = {
    command: 'sleep',
    strict: 'sleep',
    required: [{ name: 'sleepTime', number: true, docs: 'The number of seconds to sleep' }]
};
exports.default = (commandTree) => {
    commandTree.listen('/sleep', ({ argvNoOptions }) => new Promise(resolve => {
        const nSeconds = parseInt(argvNoOptions[1], 10);
        const nMillis = nSeconds * 1000;
        setTimeout(() => resolve(''), nMillis);
    }), { usage, noAuthOk: true, inBrowserOk: true });
};
//# sourceMappingURL=sleep.js.map