"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const strings = core_1.i18n('plugin-core-support');
const debug = debug_1.default('plugins/core-support/theme');
const usage = {
    theme: {
        command: 'theme',
        strict: 'theme',
        docs: strings('theme.usageDocs')
    },
    themes: {
        command: 'themes',
        strict: 'themes',
        docs: strings('theme.usageDocs')
    },
    list: {
        command: 'list',
        strict: 'list',
        docs: strings('theme.usageDocs')
    },
    reset: {
        command: 'reset',
        strict: 'reset',
        docs: strings('theme.resetUsageDocs')
    },
    set: {
        command: 'set',
        strict: 'set',
        docs: 'Set the current theme',
        required: [{ name: 'string', docs: strings('theme.setUsageRequiredDocs') }]
    }
};
const list = ({ REPL }) => __awaiter(void 0, void 0, void 0, function* () {
    const header = {
        type: 'theme',
        name: '',
        outerCSS: 'not-a-name',
        attributes: [
            { value: strings('Theme') },
            { value: strings('Style') },
            { value: strings('Provider'), outerCSS: 'hide-with-sidecar' }
        ]
    };
    const chosenTheme = (yield core_1.getPersistedThemeChoice()) || (yield core_1.getDefaultTheme());
    const currentTheme = core_1.findThemeByName(chosenTheme) ? chosenTheme : core_1.getDefaultTheme();
    debug('currentTheme', currentTheme);
    const body = core_1.flatten((yield core_1.uiThemes()).map(({ plugin, themes }) => themes.map((theme) => {
        const row = {
            type: 'theme',
            name: theme.name,
            fontawesome: 'fas fa-check',
            outerCSS: 'not-a-name',
            css: 'selected-entity',
            rowCSS: theme.name === currentTheme && 'selected-row',
            attributes: [
                {
                    key: 'NAME',
                    value: strings(theme.description) || strings(theme.name),
                    css: 'not-too-wide entity-name',
                    outerCSS: 'entity-name-group',
                    onclick: undefined
                },
                { value: strings(theme.style), outerCSS: 'pretty-narrow' },
                { value: plugin, css: 'sub-text', outerCSS: 'hide-with-sidecar' }
            ],
            onclick: undefined,
            setSelected: undefined
        };
        const onclick = () => __awaiter(void 0, void 0, void 0, function* () {
            yield REPL.qexec(`theme set ${REPL.encodeComponent(theme.name)}`);
            row.setSelected();
        });
        row.onclick = onclick;
        row.attributes[0].onclick = onclick;
        return row;
    })));
    return new core_1.Table({
        header,
        body
    });
});
const set = ({ argvNoOptions }) => __awaiter(void 0, void 0, void 0, function* () {
    const theme = argvNoOptions[argvNoOptions.indexOf('set') + 1];
    debug('set', theme);
    yield core_1.switchToTheme(theme);
    return true;
});
exports.plugin = (commandTree) => {
    debug('plugin');
    commandTree.listen('/theme/list', list, {
        usage: usage.list,
        noAuthOk: true,
        inBrowserOk: true
    });
    commandTree.listen('/themes', list, {
        usage: usage.themes,
        noAuthOk: true,
        inBrowserOk: true
    });
    commandTree.listen('/theme', list, {
        usage: usage.theme,
        noAuthOk: true,
        inBrowserOk: true
    });
    commandTree.listen('/theme/set', set, {
        usage: usage.set,
        noAuthOk: true,
        inBrowserOk: true
    });
    commandTree.listen('/theme/current', () => __awaiter(void 0, void 0, void 0, function* () { return (yield core_1.getPersistedThemeChoice()) || strings('theme.currentTheme'); }), {
        noAuthOk: true,
        inBrowserOk: true,
        hidden: true
    });
    commandTree.listen('/theme/reset', core_1.resetToDefaultTheme, {
        usage: usage.reset,
        noAuthOk: true,
        inBrowserOk: true
    });
};
//# sourceMappingURL=theme.js.map