var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Common, CLI, ReplExpect, Selectors, SidecarExpect } from '@kui-shell/test';
import { productName } from '@kui-shell/client/config.d/name.json';
describe(`about command ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    it('should open the about window via command execution', () => CLI.command('about', this.app)
        .then(ReplExpect.justOK)
        .then(SidecarExpect.open)
        .then(SidecarExpect.showing(productName))
        .then(() => this.app.client.waitForVisible(`${Selectors.SIDECAR_MODE_BUTTON_SELECTED('about')}`))
        .then(() => __awaiter(this, void 0, void 0, function* () {
        if (process.env.MOCHA_RUN_TARGET === 'electron') {
            return this.app.client.execute(() => {
                const imageSrc = document
                    .querySelector('.about-window')
                    .querySelector('img')
                    .getAttribute('src');
                const fs = require('fs');
                return fs.statSync(`${__dirname}/${imageSrc}`);
            });
        }
        if (process.env.MOCHA_RUN_TARGET === 'webpack') {
            return this.app.client.execute(() => {
                const imageSrc = document
                    .querySelector('.about-window')
                    .querySelector('img')
                    .getAttribute('src');
                const image = new Image();
                image.src = `${window.location.origin}/${imageSrc}`;
                if (image.height === 0)
                    throw new Error(`image not found: ${window.location.origin}/${imageSrc}`);
            });
        }
    }))
        .catch(Common.oops(this, true)));
    it('should open the about window via command execution with comment', () => CLI.command('about #About Kui', this.app)
        .then(ReplExpect.justOK)
        .then(SidecarExpect.open)
        .then(SidecarExpect.showing(productName))
        .then(() => this.app.client.waitForVisible(`${Selectors.SIDECAR_MODE_BUTTON_SELECTED('about')}`))
        .catch(Common.oops(this, true)));
    it('should open the about via button click', () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield Common.refresh(this);
            yield this.app.client.waitForVisible('#help-button');
            yield CLI.command('sleep 1', this.app).then(ReplExpect.blank);
            yield this.app.client.click('#help-button');
            yield this.app.client.waitForVisible(Selectors.SIDECAR);
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('about'));
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    it('should open the getting started via command execution', () => __awaiter(this, void 0, void 0, function* () {
        yield Common.refresh(this);
        return CLI.command('getting started', this.app)
            .then(ReplExpect.justOK)
            .then(SidecarExpect.open)
            .then(SidecarExpect.showing(productName))
            .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('tutorial')))
            .catch(Common.oops(this, true));
    }));
});
//# sourceMappingURL=about.js.map