"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const fs_1 = require("fs");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/editor/persisters');
const strings = core_1.i18n('plugin-editor');
const FilePersister = {
    getCode: (entity) => entity,
    saveString: strings('saveLocalFile'),
    save: (entity, editor) => new Promise((resolve, reject) => {
        const rawText = editor.getValue();
        fs_1.writeFile(entity.filepath, rawText, err => {
            if (err) {
                reject(err);
            }
            else {
                if (entity.extract) {
                    const newEntity = entity.extract(rawText, entity);
                    Object.assign(entity, newEntity);
                }
                resolve(entity);
            }
        });
    }),
    revert: (entity) => new Promise((resolve, reject) => {
        fs_1.readFile(entity.filepath, (err, data) => {
            if (err) {
                reject(err);
            }
            else {
                entity.exec.code = data.toString();
                resolve(entity);
            }
        });
    })
};
exports.persisters = {
    files: FilePersister
};
exports.save = (state) => {
    const { getEntity, editor, eventBus } = state;
    const entityRightNow = getEntity();
    const mode = (entityRightNow.persister && entityRightNow.persister.saveString) || strings('save');
    return {
        mode,
        kind: 'view',
        command: () => {
            const entity = getEntity();
            const persister = entity.persister;
            debug('persister', persister, entity);
            const { save } = entity.persister;
            entity.exec.code = editor.getValue();
            return save(entity, editor, state).then(entity => {
                entity.persister = persister;
                eventBus.emit('/editor/save', entity, { event: 'save' });
                core_1.eventBus.emit('/editor/save', entity, { event: 'save' });
                return entity;
            });
        }
    };
};
exports.revert = (state) => ({
    mode: strings('revert'),
    kind: 'view',
    command: () => {
        const entity = state.getEntity();
        const persister = entity.persister;
        debug('revert', entity);
        if (persister.revert) {
            return persister
                .revert(entity, state)
                .then(entity => {
                entity.persister = persister;
                state.editor.updateText(entity);
                state.eventBus.emit('/editor/save', entity, { event: 'revert' });
            })
                .then(() => true);
        }
        else {
            debug('no registered reverter');
        }
    }
});
//# sourceMappingURL=persisters.js.map