"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const strings = core_1.i18n('plugin-editor');
const all = ['compose', 'new', 'edit'];
const allExcept = (cmd) => all.filter(_ => _ !== cmd);
exports.toplevelUsage = {
    title: 'Editing operations',
    header: 'These commands will help you edit existing or create new assets',
    example: 'editor <command>',
    commandPrefix: 'editor',
    available: [{ command: 'edit', docs: 'Edit an existing file or entity' }]
};
exports.editUsage = (command) => ({
    command,
    strict: command,
    title: strings('Edit'),
    header: strings('header:edit'),
    docs: strings('docs:edit'),
    example: `${command} <filepath>`,
    required: [
        {
            name: '<filepath>',
            docs: strings('docs:edit:filepath'),
            file: true,
            implicitOK: ['actions', 'activations']
        }
    ],
    optional: [
        {
            name: '--create',
            boolean: true,
            docs: strings('docs:edit:create')
        },
        {
            name: '--language',
            hidden: true,
            docs: strings('docs:edit:language')
        },
        {
            name: '--name',
            hidden: true,
            docs: strings('docs:edit:name')
        },
        {
            name: '--type',
            hidden: true,
            docs: strings('docs:edit:type')
        }
    ],
    parents: [{ command: 'editor' }],
    related: allExcept('edit')
});
//# sourceMappingURL=usage.js.map