"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const exec_1 = require("./exec");
const apiVersion_1 = require("./apiVersion");
const command_prefix_1 = require("../command-prefix");
const help_1 = require("./help");
function doGet(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const { command, argvNoOptions } = args;
        const projIdx = argvNoOptions.indexOf('get') + 1;
        const releaseIdx = argvNoOptions.length - 1;
        const projection = projIdx < releaseIdx ? argvNoOptions[projIdx] : undefined;
        const releaseName = argvNoOptions[releaseIdx];
        const basic = /REVISION:\s+(\S+)[\n\r]+RELEASED:\s+([^\n\r]+)[\n\r]+CHART:\s+(\S+)/;
        const response = yield exec_1.default(args);
        if (projection) {
            return response;
        }
        const match = response.match(basic);
        if (!match) {
            return help_1.doHelpIfRequested(args, response);
        }
        const revision = match[1];
        const creationTimestamp = match[2];
        const chart = match[3];
        const endOfBasicSection = Math.min(response.indexOf('USER-SUPPLIED VALUES'), response.indexOf('COMPUTED VALUES'));
        return {
            apiVersion: apiVersion_1.default,
            kind: 'HelmRelease',
            metadata: {
                name: releaseName,
                generation: revision,
                creationTimestamp
            },
            summary: {
                content: response.substring(0, endOfBasicSection).trim(),
                contentType: 'yaml'
            },
            isSimulacrum: true,
            originatingCommand: command,
            data: response,
            modes: []
        };
    });
}
exports.default = (registrar) => {
    registrar.listen(`/${command_prefix_1.default}/helm/get`, doGet, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=get.js.map