"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const exec_1 = require("./exec");
const help_1 = require("./help");
const command_prefix_1 = require("../command-prefix");
const name = /^NAME:\s+([\w-]+)/;
function doInstall(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield exec_1.default(args);
        if (help_1.isUsage(args)) {
            help_1.doHelp(response);
        }
        else {
            const releaseName = response.match(name)[1];
            return args.REPL.qexec(`helm get ${args.REPL.encodeComponent(releaseName)}`).catch(err => {
                console.error('error in helm get for helm install', err);
                return response;
            });
        }
    });
}
exports.default = (registrar) => {
    registrar.listen(`/${command_prefix_1.default}/helm/install`, doInstall, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=install.js.map