import { i18n } from '@kui-shell/core';
import { isHelmRelease } from '../models/release';
const strings = i18n('plugin-helmui');
export default {
    when: isHelmRelease,
    mode: {
        mode: 'status',
        label: strings('Show Status'),
        kind: 'drilldown',
        command: (_, resource) => {
            return `helm status ${resource.metadata.name}`;
        }
    }
};
//# sourceMappingURL=status.js.map