"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const isKubectl = (str) => /^k(ubectl)?$/.test(str);
exports.default = (registrar) => {
    if (core_1.inBrowser() && !core_1.hasProxy()) {
        return;
    }
    registrar.catchall((argv) => {
        return isKubectl(argv[0]) || (argv[0] === command_prefix_1.default && isKubectl(argv[1]));
    }, exec_1.doExecWithPty, 1, { inBrowserOk: true });
};
//# sourceMappingURL=catchall.js.map