"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const flags_1 = require("./flags");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const get_1 = require("./get");
const verb = 'top';
const doTop = (command) => function _doTop(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield exec_1.exec(args);
        return get_1.doGetAsTable(command, args, response, verb);
    });
};
exports.default = (commandTree) => {
    commandTree.listen(`/${command_prefix_1.default}/kubectl/${verb}/node`, doTop('kubectl'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/k/${verb}/node`, doTop('k'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/kubectl/${verb}/pod`, doTop('kubectl'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/k/${verb}/pod`, doTop('k'), flags_1.default);
};
//# sourceMappingURL=top.js.map