"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('k8s/view/util/selectors');
exports.selectorToString = (selector) => {
    if (selector.matchLabels) {
        return exports.selectorToString(selector.matchLabels);
    }
    else if (selector.matchExpressions) {
        return '';
    }
    const stringified = Object.keys(selector)
        .map(key => `-l ${key}=${selector[key]}`)
        .join(' ');
    debug('selectorToString', stringified, selector);
    return stringified;
};
//# sourceMappingURL=selectors.js.map