"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const css_for_value_1 = require("../css-for-value");
const traffic_light_1 = require("../../model/traffic-light");
const resource_1 = require("../../model/resource");
const util_1 = require("../../util/util");
const strings = core_1.i18n('plugin-kubeui');
function command(tab, resource, args) {
    const cmdGetPodEvents = `${util_1.getCommandFromArgs(args)} get events --field-selector involvedObject.name=${resource.metadata.name},involvedObject.namespace=${resource.metadata.namespace} -n ${resource.metadata.namespace}`;
    const customColumns = 'wide';
    return `${cmdGetPodEvents} -o "${customColumns}"`;
}
function hasEvents(resource) {
    return resource_1.isCrudableKubeResource(resource) && !resource_1.isEvent(resource) && resource_1.isNamespaced(resource);
}
exports.eventsMode = {
    when: hasEvents,
    mode: {
        mode: 'events',
        label: strings('Show Events'),
        command,
        kind: 'drilldown'
    }
};
exports.eventsBadge = {
    when: resource_1.isEvent,
    badge: (event) => {
        const cssFromReason = css_for_value_1.default[event.reason];
        return {
            title: cssFromReason ? event.reason : event.type,
            css: cssFromReason ||
                (event.type === 'Error' ? traffic_light_1.default.Red : event.type === 'Warning' ? traffic_light_1.default.Yellow : undefined)
        };
    }
};
//# sourceMappingURL=events.js.map