"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const fqn_1 = require("../../../controller/kubectl/fqn");
const resource_1 = require("../../model/resource");
const util_1 = require("../../../lib/util/util");
const strings = core_1.i18n('plugin-kubeui');
function command(tab, { involvedObject: { apiVersion, kind, name, namespace } }, args) {
    return `${util_1.getCommandFromArgs(args)} get ${fqn_1.fqn(apiVersion, core_1.encodeComponent(kind), core_1.encodeComponent(name), core_1.encodeComponent(namespace || 'default'))} -o yaml`;
}
const mode = {
    when: resource_1.hasInvolvedObject,
    mode: {
        mode: 'involvedObject',
        label: strings('Show Involved Object'),
        command,
        kind: 'drilldown'
    }
};
exports.default = mode;
//# sourceMappingURL=involved-object.js.map