"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const strings = core_1.i18n('plugin-kubeui');
function getLastAppliedRaw(resource) {
    const annotations = resource.metadata.annotations;
    return annotations !== undefined ? annotations['kubectl.kubernetes.io/last-applied-configuration'] : undefined;
}
function hasLastApplied(resource) {
    return getLastAppliedRaw(resource) !== undefined;
}
const renderLastApplied = (tab, resource) => __awaiter(void 0, void 0, void 0, function* () {
    const { safeDump } = yield Promise.resolve().then(() => require('js-yaml'));
    return {
        content: safeDump(JSON.parse(getLastAppliedRaw(resource))),
        contentType: 'yaml'
    };
});
exports.default = {
    when: hasLastApplied,
    mode: {
        mode: 'last applied',
        label: strings('lastApplied'),
        content: renderLastApplied
    }
};
//# sourceMappingURL=last-applied.js.map