"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const resource_1 = require("../../model/resource");
const get_namespaces_1 = require("../../../controller/kubectl/get-namespaces");
const mode = 'resources';
const label = core_1.i18n('plugin-kubeui')(mode);
function content(tab, resource) {
    return get_namespaces_1.doSummarizeNamedNamespace(tab, resource.metadata.name);
}
const summaryMode = {
    when: resource_1.isNamespace,
    mode: {
        mode,
        label,
        content
    }
};
exports.default = summaryMode;
//# sourceMappingURL=namespace-summary.js.map