import { inBrowser, hasProxy } from '@kui-shell/core';
import { doExecWithPty } from './exec';
import commandPrefix from '../command-prefix';
const isKubectl = (str) => /^k(ubectl)?$/.test(str);
export default (registrar) => {
    if (inBrowser() && !hasProxy()) {
        return;
    }
    registrar.catchall((argv) => {
        return isKubectl(argv[0]) || (argv[0] === commandPrefix && isKubectl(argv[1]));
    }, doExecWithPty, 1, { inBrowserOk: true });
};
//# sourceMappingURL=catchall.js.map