import flags from './flags';
import { doExecWithStatus } from './exec';
import commandPrefix from '../command-prefix';
import { FinalState } from '../../lib/model/states';
const verbs = ['create', 'apply'];
export const doCreate = (verb, command = 'kubectl') => doExecWithStatus(verb, FinalState.OnlineLike, command);
export default (registrar) => {
    verbs.forEach(verb => {
        const handler = doCreate(verb);
        registrar.listen(`/${commandPrefix}/kubectl/${verb}`, handler, flags);
        registrar.listen(`/${commandPrefix}/k/${verb}`, handler, flags);
    });
};
//# sourceMappingURL=create.js.map