import { Store, setHasAuth } from '@kui-shell/core';
const localStorageKey = {
    auth: 'kui.k8s.auth'
};
export const setAuth = (kubeconfigString, ca, cafile) => {
    const auth = {
        kubeconfig: kubeconfigString,
        ca: ca,
        cafile
    };
    setHasAuth('k8s', auth);
    Store().setItem(localStorageKey.auth, JSON.stringify(auth));
};
export const restoreAuth = () => {
    const maybe = Store().getItem(localStorageKey.auth);
    if (maybe) {
        try {
            setHasAuth('k8s', JSON.parse(maybe));
        }
        catch (err) {
            console.error('error parsing k8s auth from localStorage', err);
        }
    }
};
//# sourceMappingURL=auth.js.map