const States = {
    Available: 'Available',
    Active: 'Active',
    Online: 'Online',
    Ready: 'Ready',
    Running: 'Running',
    Completed: 'Completed',
    Succeeded: 'Succeeded',
    ProvisionedSuccessfully: 'ProvisionedSuccessfully',
    Deployed: 'Deployed',
    ChannelReady: 'ChannelReady',
    Addressable: 'Addressable',
    Offline: 'Offline',
    Undeployed: 'Offline',
    Failed: 'Failed',
    Disparity: 'Disparity',
    NotProvisioned: 'NotProvisioned',
    Unschedulable: 'Unschedulable',
    ErrImagePull: 'ErrImagePull',
    ImagePullBackOff: 'ImagePullBackOff',
    PodInitializing: 'PodInitializing',
    Retrying: 'Retrying',
    Deleting: 'Deploying',
    Deploying: 'Deploying',
    Pending: 'Pending',
    Waiting: 'Waiting',
    Provisioning: 'Provisioning',
    Conflict: 'Conflict'
};
export var FinalState;
(function (FinalState) {
    FinalState[FinalState["NotPendingLike"] = 0] = "NotPendingLike";
    FinalState[FinalState["OnlineLike"] = 1] = "OnlineLike";
    FinalState[FinalState["OfflineLike"] = 2] = "OfflineLike";
})(FinalState || (FinalState = {}));
const stateGroups = {};
const groupOf = (A) => A.reduce((group, state) => {
    group[state] = true;
    return group;
}, {});
stateGroups[FinalState.OnlineLike] = groupOf([
    States.Available,
    States.Active,
    States.Online,
    States.Ready,
    States.Running,
    States.ProvisionedSuccessfully,
    States.Deployed,
    States.ChannelReady,
    States.Addressable,
    States.Completed,
    States.Succeeded
]);
const isOnlineLike = (state) => stateGroups[FinalState.OnlineLike][state];
stateGroups[FinalState.OfflineLike] = groupOf([
    States.Offline,
    States.Undeployed,
    States.Failed,
    States.Disparity,
    States.NotProvisioned,
    States.Unschedulable,
    States.ErrImagePull
]);
const isOfflineLike = (state) => !!stateGroups[FinalState.OfflineLike][state];
const isPendingLike = (state) => !isOnlineLike(state) && !isOfflineLike(state);
export function isDone(newState, finalState) {
    const done = newState === States.Failed ||
        (finalState === FinalState.NotPendingLike && !isPendingLike(newState)) ||
        (finalState === FinalState.OnlineLike && isOnlineLike(newState)) ||
        (finalState === FinalState.OfflineLike && isOfflineLike(newState));
    return done;
}
//# sourceMappingURL=states.js.map