import { hasInvolvedObject } from '../model/resource';
export default function extract(resource) {
    const metadata = resource && resource.metadata;
    const appFromNameAndInstance = metadata &&
        metadata.labels &&
        metadata.labels['app.kubernetes.io/name'] &&
        metadata.labels['app.kubernetes.io/instance'] &&
        `${metadata.labels['app.kubernetes.io/instance']}-${metadata.labels['app.kubernetes.io/name']}`;
    const app = appFromNameAndInstance ||
        (metadata && metadata.labels && metadata.labels.app) ||
        (hasInvolvedObject(resource) && resource.involvedObject.name);
    if (app) {
        const pattern = `(^${app})[-.]([0-9a-zA-Z]+-.+|[0-9a-z]{16})`;
        const match = resource.metadata.name.match(new RegExp(pattern));
        const name = match && match[1];
        const nameHash = match && match[2];
        return { app, name, nameHash };
    }
    else {
        return {};
    }
}
//# sourceMappingURL=name.js.map