var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import commandPrefix from '../../controller/command-prefix';
export const maybeAsDate = str => {
    try {
        const localized = new Date(str).toLocaleString();
        if (localized === 'Invalid Date') {
            return str;
        }
        else {
            return localized;
        }
    }
    catch (err) {
        return str;
    }
};
export const isDirectory = (filepath) => new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
    const { inBrowser } = yield import('@kui-shell/core');
    if (inBrowser()) {
        resolve(false);
    }
    else {
        const { lstat } = yield import('fs');
        lstat(filepath, (err, stats) => {
            if (err) {
                if (err.code === 'ENOENT') {
                    resolve(undefined);
                }
                else {
                    reject(err);
                }
            }
            else {
                resolve(stats.isDirectory());
            }
        });
    }
}));
export const toOpenWhiskFQN = ({ kind, spec, metadata }) => {
    if (kind === 'Function' || kind === 'Composition') {
        const actionName = spec.name || metadata.name;
        const packageName = spec.package;
        return {
            type: kind === 'Function' ? 'action' : 'app',
            packageName,
            actionName,
            fqn: packageName ? `${packageName}/${actionName}` : actionName
        };
    }
    else if (kind === 'Composition') {
        return { type: 'app', fqn: metadata.name };
    }
    else if (kind === 'Package' || kind === 'Rule' || kind === 'Trigger') {
        return { type: kind.toLowerCase(), fqn: metadata.name };
    }
    else {
        return { type: 'unknown', fqn: metadata.name };
    }
};
export class StatusError extends Error {
}
export class TryLaterError extends StatusError {
}
export class NotFoundError extends StatusError {
    constructor(message, code = 404) {
        super(message);
        this.code = code;
    }
}
export const getCommandFromArgs = (args) => {
    return args.argvNoOptions[0] === commandPrefix ? args.argvNoOptions[1] : args.argvNoOptions[0];
};
export const commandWithoutResource = (args) => {
    if (args.argvNoOptions[0] === commandPrefix) {
        return args.argvNoOptions.length === 3;
    }
    else {
        return args.argvNoOptions.length === 2;
    }
};
//# sourceMappingURL=util.js.map