import { i18n, encodeComponent } from '@kui-shell/core';
import { fqn } from '../../../controller/kubectl/fqn';
import { hasInvolvedObject } from '../../model/resource';
import { getCommandFromArgs } from '../../../lib/util/util';
const strings = i18n('plugin-kubeui');
function command(tab, { involvedObject: { apiVersion, kind, name, namespace } }, args) {
    return `${getCommandFromArgs(args)} get ${fqn(apiVersion, encodeComponent(kind), encodeComponent(name), encodeComponent(namespace || 'default'))} -o yaml`;
}
const mode = {
    when: hasInvolvedObject,
    mode: {
        mode: 'involvedObject',
        label: strings('Show Involved Object'),
        command,
        kind: 'drilldown'
    }
};
export default mode;
//# sourceMappingURL=involved-object.js.map