var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors, Util } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const commands = ['kubectl', 'k'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
commands.forEach(command => {
    Common.localDescribe(`${command} get summary tab describe ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        const testRawTab = (ctx) => __awaiter(this, void 0, void 0, function* () {
            yield ctx.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield ctx.app.client.click(Selectors.SIDECAR_MODE_BUTTON('raw'));
            return ctx.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const ok = yield Util.getValueFromMonaco(ctx.app).then(Util.expectYAMLSubset({
                    apiVersion: 'v1',
                    kind: 'Pod',
                    metadata: {
                        name: 'nginx',
                        namespace: ns
                    }
                }, false));
                return ok;
            }));
        });
        const testSummaryTab = (ctx) => __awaiter(this, void 0, void 0, function* () {
            yield ctx.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON(defaultModeForGet));
            yield ctx.app.client.click(Selectors.SIDECAR_MODE_BUTTON(defaultModeForGet));
            return ctx.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const name = 'nginx';
                const actualText = yield Util.getValueFromMonaco(ctx.app);
                return new RegExp(`NAME:\\s+${name}`).test(actualText);
            }));
        });
        allocateNS(this, ns, command);
        const execCommand = command === 'k' ? 'kubectl' : command;
        it(`should give help for known outer command: ${command} describe --help`, () => CLI.command(`${command} describe -h`, this.app)
            .then(ReplExpect.errorWithPassthrough(500))
            .then(N => Promise.all([
            this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} h4.usage-error-title[data-title="Options:"]`),
            this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} .bx--breadcrumb-item .bx--no-link[data-label="describe"]`),
            this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} .bx--breadcrumb-item .bx--link[data-label="${execCommand}"]`)
        ]))
            .catch(Common.oops(this)));
        it(`should fail with suggestion for invalid command syntax via ${command} describe`, () => {
            return CLI.command(`${command} describe`, this.app)
                .then(ReplExpect.error(500, `error: You must specify the type of resource to describe. Use "${execCommand} api-resources" for a complete list of supported resources`))
                .catch(Common.oops(this, true));
        });
        Common.localIt(`should fail with 404 for unknown resource type via ${command}`, () => {
            const fakeType = 'yoyoyo1334u890724';
            return CLI.command(`${command} get ${fakeType} productPage -o yaml`, this.app)
                .then(ReplExpect.error(404))
                .catch(Common.oops(this, true));
        });
        it(`should create sample pod from URL via ${command}`, () => {
            return CLI.command(`${command} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod -n ${ns}`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                .then(selector => waitForGreen(this.app, selector))
                .catch(Common.oops(this, true));
        });
        it(`should describe that pod via ${command}`, () => {
            return CLI.command(`${command} describe pod nginx -n ${ns}`, this.app)
                .then(ReplExpect.justOK)
                .then(SidecarExpect.open)
                .then(SidecarExpect.mode(defaultModeForGet))
                .then(SidecarExpect.showing('nginx', undefined, undefined, ns))
                .catch(Common.oops(this, true));
        });
        it(`should summarize that pod via ${command}`, () => {
            return CLI.command(`${command} get pod nginx -n ${ns} -o yaml`, this.app)
                .then(ReplExpect.justOK)
                .then(SidecarExpect.open)
                .then(SidecarExpect.mode(defaultModeForGet))
                .then(SidecarExpect.showing('nginx', undefined, undefined, ns))
                .catch(Common.oops(this, true));
        });
        it(`should flip to raw tab`, () => testRawTab(this).catch(Common.oops(this, true)));
        it(`should flip to summary tab`, () => testSummaryTab(this).catch(Common.oops(this, true)));
        it(`should flip to raw tab`, () => testRawTab(this).catch(Common.oops(this, true)));
        it(`should flip to summary tab`, () => testSummaryTab(this).catch(Common.oops(this, true)));
        it('should initiate deletion of the pod via sidecar deletion button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('delete'));
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('delete'));
                yield this.app.client.waitForExist('#confirm-dialog .bx--btn--danger');
                yield this.app.client.click('#confirm-dialog .bx--btn--danger');
                yield this.app.client.waitForExist('#confirm-dialog', 20000, true);
            }
            catch (err) {
                yield Common.oops(this, true);
            }
        }));
        it('should show that the click-delete has started', () => {
            let idx = 0;
            return this.app.client
                .waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const value = yield this.app.client.getValue(Selectors.PROMPT_FINAL);
                if (++idx > 5) {
                    console.error(`kubectl get ${process.env.MOCHA_RUN_TARGET || ''} still waiting for delete command`);
                }
                return /delete/.test(value);
            }))
                .catch(Common.oops(this, true));
        });
        it('should wait for that click-delete to finish', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const count = parseInt(yield this.app.client.getAttribute(Selectors.PROMPT_BLOCK_FINAL, 'data-input-count'), 10);
                const newResourceSelector = yield ReplExpect.okWithCustom({
                    selector: Selectors.BY_NAME('nginx')
                })({ app: this.app, count });
                yield waitForRed(this.app, newResourceSelector);
            }
            catch (err) {
                yield Common.oops(this, true);
            }
        }));
        deleteNS(this, ns, command);
    });
});
//# sourceMappingURL=describe.js.map