var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, Keys, ReplExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, createNS, allocateNS, deleteNS, typeSlowly } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
commands.forEach(command => {
    describe(`${command} edit ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        const createIt = (name) => {
            it(`should create sample pod ${name} from URL via ${command}`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const selector = yield CLI.command(`${command} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }));
                    yield waitForGreen(this.app, selector);
                }
                catch (err) {
                    yield Common.oops(this, true)(err);
                }
            }));
        };
        const editIt = (name, quit) => {
            it(`should edit it via ${command} edit, and using ${quit} to quit`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const res = yield CLI.command(`${command} edit pod ${name} ${inNamespace}`, this.app);
                    const rows = Selectors.xtermRows(res.count);
                    yield this.app.client.waitForExist(rows);
                    yield this.app.client.waitForExist(`tab.visible.xterm-alt-buffer-mode`);
                    yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                        try {
                            const txt = yield CLI.getTextContent(this.app, rows);
                            return /apiVersion: v/.test(txt);
                        }
                        catch (err) {
                            console.error(err);
                            return false;
                        }
                    }));
                    yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                        yield this.app.client.keys(Keys.ESCAPE);
                        yield typeSlowly(this.app, `${quit}${Keys.ENTER}`);
                        return Promise.resolve(res)
                            .then(ReplExpect.okWithTextContent('cancelled', false, false))
                            .then(() => true)
                            .catch(() => false);
                    }));
                }
                catch (err) {
                    yield Common.oops(this, true)(err);
                }
            }));
        };
        allocateNS(this, ns);
        const nginx = 'nginx';
        createIt(nginx);
        editIt(nginx, ':wq!');
        editIt(nginx, ':wq');
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=edit.js.map