import { Common } from '@kui-shell/test';
import { cli as kui, kuiElectron } from '@kui-shell/core/tests/lib/headless';
import { createNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import { dirname } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const doTests = (ctx, impl) => {
    before(Common.before(ctx, { noApp: true }));
    after(Common.after(ctx));
    const ns = createNS();
    const inNamespace = `-n ${ns}`;
    xit(`should create a namespace ${ns} `, () => {
        return kui
            .command(`kubectl create namespace ${ns}`, ctx.app)
            .then(kui.expectOK(`namespace/${ns} created`))
            .catch(Common.oops(ctx, true));
    });
    xit('should create sample pod from local file', () => {
        return kui
            .command(`kubectl create -f ${ROOT}/data/k8s/headless/pod.yaml ${inNamespace}`, ctx.app)
            .then(kui.expectOK('nginx'))
            .catch(Common.oops(ctx, true));
    });
    xit('should list the new pod in electron', () => {
        return impl
            .command(`kubectl get pods ${inNamespace} --ui`, ctx.app)
            .then(impl.expectOK('nginx'))
            .catch(Common.oops(ctx, true));
    });
    xit(`should delete the namespace ${ns} `, () => {
        return kui
            .command(`kubectl delete namespace ${ns}`, ctx.app)
            .then(kui.expectOK(`namespace "${ns}" deleted`))
            .catch(Common.oops(ctx, true));
    });
};
Common.localDescribe('k8s with electron via bin/kui', function () {
    doTests(this, kuiElectron);
});
//# sourceMappingURL=dash-dash-ui.js.map